## Train Degradation Removal Module

### Prepare Degremoval Environment 

```sh
conda create -n degremoval python=3.8
conda activate degremoval
pip install -r requirements.txt
```

### Train Degradation Mapper

```sh
accelerate launch --config_file option/1_gpu.json --main_process_port 25656 \
  	DegRemovalModule/train/degradation_mapper.py \
  	--pretrained_stable_diffusion_path="sd2.1_path" \
  	--pretrained_clip_model_path="clip-vit-large-patch14_path" 
  	--num_words=30 \
	--train_data_dir="FFHQ_dataset_path" \
    --placeholder_token="S" --resolution=512 --train_batch_size=4 --gradient_accumulation_steps=4 \
    --max_train_steps=17500 --learning_rate=1e-06 --scale_lr --lr_scheduler="constant" --lr_warmup_steps=0 \
    --output_dir="./experiments/mapper" \
    --save_steps=50
```

### Train Degradation Remover

```sh
accelerate launch --config_file option/1_gpu.json --main_process_port 25656 \
    DegRemovalModule/train/degradation_remover.py \
    --pretrained_stable_diffusion_path="sd2.1_path" \
  	--pretrained_clip_model_path="clip-vit-large-patch14_path" 
  	--num_words=30 \
	--train_data_dir="FFHQ_dataset_path" \
    --placeholder_token="S" --resolution=512 --train_batch_size=4 --gradient_accumulation_steps=4 \
    --max_train_steps=17500 --learning_rate=1e-06 --scale_lr --lr_scheduler="constant" --lr_warmup_steps=0 \
    --output_dir="./experiments/remover" \
    --mapper_path="mapper_path" \
    --save_steps=50
```

